// 1ms timer

#ifndef _TIMER_H
#define _TIMER_H

#include "global.h"

/**************************************************************************
DOES:    Initializer - performs initialization
RETURNS: nothing
***************************************************************************/
extern void Timer_Init(void);

/**************************************************************************
DOES:    Close - performs cleanup
RETURNS: nothing
***************************************************************************/
extern void Timer_Close(void);

/**************************************************************************
DOES:    This function reads a 1 millisecond timer tick. The timer tick
must be a uint16_t and must be incremented once per millisecond.
RETURNS: 1 millisecond timer tick
**************************************************************************/
extern uint16_t Timer_GetTime(void);

/**************************************************************************
DOES:    This function compares a uint16_t timestamp to the internal
timer tick and returns 1 if the timestamp expired/passed.
RETURNS: 1 if timestamp expired/passed
0 if timestamp is not yet reached
NOTES:   The maximum timer runtime measurable is 0x8000 (about 32 seconds).
For the usage in MicroCANopen that is sufficient.
**************************************************************************/
extern uint8_t Timer_IsTimeExpired(uint16_t timestamp);

/**************************************************************************
DOES:    Pauses execution for specified number of milliseconds
RETURNS: nothing
***************************************************************************/
extern void Timer_Sleep(unsigned long milliseconds);

#endif // _TIMER_H
